<?php

namespace Mtc\ContentManager\Rules;

use Illuminate\Contracts\Validation\Rule;

class MaxNumericValue implements Rule
{
    public function __construct(protected readonly int $maxValue)
    {
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return $value < $this->maxValue;
    }

    public function message()
    {
        return 'The :attribute must be less than ' . $this->maxValue;
    }
}
