<?php

namespace Mtc\ContentManager\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Contracts\ContentElement;
use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\GlobalContent;

class MinNumericValue implements Rule
{
    public function __construct(protected readonly int $minValue)
    {
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        return $value >= $this->minValue;
    }

    public function message()
    {
        return 'The :attribute must be greater than ' . $this->minValue;
    }
}
