<?php

namespace Mtc\ContentManager\Traits;

use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\Relations\MorphOne;
use Mtc\ContentManager\Contracts\MediaUse;

trait HasMedia
{
    /**
     * Relationship with vehicle images/media
     *
     * @return MorphMany
     */
    public function mediaUses(): MorphMany
    {
        return $this->morphMany(config('media.media_use_model'), 'owner')
            ->orderBy('order');
    }

    /**
     * Relationship with primary media file
     *
     * @return MorphOne
     */
    public function primaryMediaUse(): MorphOne
    {
        return $this->morphOne(config('media.media_use_model'), 'owner')
            ->where('primary', 1);
    }


    /**
     * Get the primary image for vehicle in $dimensions size as url
     *
     * @param string $dimensions
     * @return string|null
     */
    public function getPreviewImage(string $dimensions): ?string
    {
        /** @var MediaUse $image */
        if ($this->relationLoaded('primaryMediaUse')) {
            $image = $this->primaryMediaUse;
        } elseif ($this->relationLoaded('mediaUses')) {
            $image = $this->mediaUses
                ->sortBy('primary')
                ->first();
        } else {
            $image = $this->mediaUses()
                ->orderByDesc('primary')
                ->first();
        }

        return $image?->getUrl($dimensions);
    }
}
