<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Mtc\ContentManager\Models\MediaSize;

class MediaSizeList extends JsonResource
{
    public static $wrap = '';
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'data' => $this->data(),
            'default_columns' => [
                'model',
                'dimensions',
            ]
        ];
    }

    private function data(): array
    {
        return $this->resource
            ->map(fn(MediaSize $size) => [
                'id' => $size->id,
                'title' => $size->label,
                'metaItems' => [
                    'model' => ucfirst($size->model),
                    'dimensions' => $size->width . 'x' . $size->height,
                ]
            ])
            ->toArray();
    }
}
