<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\ImageSize;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\ContentManager\Models\MediaUse;

class ChangeMediaSizeDimensions implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public $timeout = 0;

    public function __construct(protected readonly MediaSize $mediaSize, protected readonly array $original)
    {
        $this->onQueue('media');
    }

    public function handle()
    {
        MediaUse::query()
            ->with('media')
            ->where('owner_type', $this->mediaSize->model)
            ->chunk(100, fn(Collection $chunk) => $chunk->each(function (MediaUse $use) {
                try {
                    Media::changeMediaSize(
                        $use,
                        ImageSize::fromArray($this->original),
                        ImageSize::fromArray($this->mediaSize->getAttributes())
                    );
                } catch (\Exception $exception) {
                    Log::error('Failed to resize image', [
                        $exception->getMessage(),
                        $this->mediaSize->width,
                        $this->mediaSize->height,
                        $this->original,
                        $use,
                        $exception->getTrace(),
                    ]);
                }
            }));
    }
}
