<?php

namespace Mtc\ContentManager\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Str;

class IsSlugRule implements Rule
{
    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (is_null($value)) {
            return true;
        }
        $slug = collect(explode('/', trim($value, '/')))
            ->map(fn($part) => Str::slug($part))
            ->implode('/');
        return $slug === $value;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'Slug should have no forward or trailing slash or domain, lowercase alpha-numeric with dashes only';
    }
}
