<?php

namespace Mtc\ContentManager\Facades;

use Illuminate\Support\Facades\Facade;
use Mtc\ContentManager\Contracts\PageModel;
use Mtc\ContentManager\Contracts\VersionModel;
use Mtc\ContentManager\PageRepository;

/**
 *
 * @method static void findFromUrl(string $url)
 * @method static void save(PageModel $page, array $input, int|null $id)
 * @method static VersionModel|null savePageVersion(PageModel $page, array $content, int|null $author_id)
 * @method static void saveVersion(VersionModel $version, array $input, int|null $id)
 * @method static bool canRemove(int $pageId)
 * @method static bool remove(int $pageId)
 * @method static PageModel create(string $title, int|null $templateId, ?string $category = null)
 * @method static void updatePageTextField(PageModel $page)
 * @method static VersionModel restorePage(int $pageId)
 * @method static void restoreVersion(int $versionId)
 * @method static VersionModel markVersionForReview(int $pageId, int $versionId)
 * @method static VersionModel markVersionAsChangesRequested(int $pageId, int $versionId)
 * @method static void syncContentWithTemplate(int $pageId)
 * @method static PageModel copyPage(int $pageId, string $title, bool $with_content)
 * @see PageRepository
 *
 */
class Page extends Facade
{
    /**
     * Define the facade accessor
     *
     * @return string
     */
    protected static function getFacadeAccessor()
    {
        return 'page_repository';
    }
}
