<?php

namespace Mtc\ContentManager\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Str;
use Mtc\ContentManager\Models\ContentElementField;

class ElementDoesNotExceedMaxDepth implements Rule
{
    private int $depth = 0;

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (empty($value)) {
            return true;
        }
        $this->depth = Config::get('pages.max_element_depth');
        return $this->getElementDepth([$value]) <= $this->depth;
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return "Max element depth of $this->depth has been exceeded.";
    }

    /**
     * @param array $element_ids
     * @param int $depth Starts at 2 as we run validation on 1st level and pass 2nd level to the method
     * @return int
     */
    private function getElementDepth(array $element_ids, int $depth = 2): int
    {
        $child_ids = ContentElementField::query()
            ->whereIn('element_id', $element_ids)
            ->pluck('child_element_id')
            ->unique()
            ->filter()
            ->toArray();

        return !empty($child_ids)
            ? $this->getElementDepth($child_ids, $depth + 1)
            : $depth;
    }
}
