<?php

namespace Mtc\ContentManager\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\ContentManager\Models\MenuEntry;

class MenuEntryFactory extends Factory
{
    protected $model = MenuEntry::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'menu_id' => random_int(1, 50),
            'element_id' => random_int(1, 50),
            'name' => $this->faker->word(),
            'url' => $this->faker->url(),
            'content' => [],
            'data' => [],
            'is_enabled' => random_int(0, 1),
        ];
    }
}
