<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class MediaEntryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'media' => [
                'id' => $this->resource->media?->id,
                'title' => $this->resource->media?->title,
                'extension' => pathinfo($this->resource->media?->src, PATHINFO_EXTENSION),
                'type' => $this->resource->media?->type,
                'src' => $this->resource->media?->getSquareThumbUrlAttribute(),
                'primary' => $this->resource->primary,
                'secondary' => $this->resource->secondary,
                'interior' => $this->resource->interior,
                'exterior' => $this->resource->exterior,
                'hex1' => $this->resource->media?->hex1,
                'hex2' => $this->resource->media?->hex2,
            ],
            'id' => $this->resource->id,
            'allowed_sizes' => $this->resource->allowed_sizes,
            'order' => $this->resource->order,
        ];
    }
}
