<?php

namespace Mtc\ContentManager\Tests\Unit;

use Mtc\ContentManager\ImageSize;
use Mtc\ContentManager\Tests\TestCase;

class ImageSizeTest extends TestCase
{
    public function testFileDestinationHasFileDimensions(): void
    {
        $size = new ImageSize(123, 321, true);
        self::assertStringContainsString('123', $size->fileDestination('test.png', '/2025-Apr/orig/'));
        self::assertStringContainsString('321', $size->fileDestination('test.png', '/2025-Apr/orig/'));

    }
    public function testFileDestinationHasFileName(): void
    {
        $size = new ImageSize(123, 321, true);
        self::assertStringContainsString('test.png', $size->fileDestination('test.png', '/2025-Apr/orig/'));

    }

    public function testPathOnDiskHasDimensions(): void
    {
        $size = new ImageSize(123, 321, true);
        self::assertStringContainsString('123', $size->pathOnDisk('test.png', '/2025-Apr/orig/'));
        self::assertStringContainsString('321', $size->pathOnDisk('test.png', '/2025-Apr/orig/'));
    }

    public function testPathOnDiskContainsFilename(): void
    {
        $size = new ImageSize(100, 100, true);
        self::assertStringContainsString('test.png', $size->pathOnDisk('test.png', '/2025-Apr/orig/'));
    }

    public function testGetWidth(): void
    {
        $test_a = new ImageSize(100, 100, true);
        $test_b = new ImageSize(100, 200, false);

        self::assertEquals(100, $test_b->getWidth());
        self::assertEquals(100, $test_a->getWidth());
    }

    public function testGetHeight(): void
    {
        $test_a = new ImageSize(100, 100, true);
        $test_b = new ImageSize(100, 200, false);

        self::assertEquals(100, $test_a->getHeight());
        self::assertEquals(200, $test_b->getHeight());
    }

    public function testGetAllowCompression(): void
    {
        $true_test = new ImageSize(100, 100, true);
        $false_test = new ImageSize(100, 200, false);

        self::assertTrue($true_test->getAllowCompression());
        self::assertFalse($false_test->getAllowCompression());
    }

    public function testGetWidthFromArrayConfig(): void
    {
        $test_a = ImageSize::fromArray([
            'width' => 100
        ]);
        $test_b = ImageSize::fromArray([
            'height' => 200,
            'width' => 200
        ]);

        self::assertEquals(100, $test_a->getWidth());
        self::assertEquals(200, $test_b->getWidth());

    }

    public function testGetHeightFromArrayConfig(): void
    {
        $test_a = ImageSize::fromArray([
            'height' => 100
        ]);
        $test_b = ImageSize::fromArray([
            'width' => 200,
            'height' => 200,
        ]);

        self::assertEquals(100, $test_a->getHeight());
        self::assertEquals(200, $test_b->getHeight());
    }

    public function testGetAllowCompressionArrayConfig(): void
    {
        $true_test = ImageSize::fromArray([
            'allow_compression' => true
        ]);
        $false_test = ImageSize::fromArray([
            'width' => 200,
            'height' => 200,
            'allow_compression' => false
        ]);

        self::assertTrue($true_test->getAllowCompression());
        self::assertFalse($false_test->getAllowCompression());
    }

    public function testFileUrl(): void
    {
        $size = ImageSize::fromArray([
            'width' => 200,
            'height' => 200,
        ]);

        self::assertStringContainsString('200x200/dummy_file.png', $size->fileUrl('dummy_file.png', '/2025-Apr/orig/'));
    }
}
