<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Log;
use Mtc\ContentManager\Contracts\Comment;

class CommentListResource extends JsonResource
{
    public static $wrap = '';
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        if ($this->resource instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator) {
            $this->resource
                ->through(fn(Comment $comment) => $this->mapRecord($comment));
        } else {
            $this->resource = $this->resource
                ->map(fn(Comment $comment) => $this->mapRecord($comment));
        }
        return [
            'comments' => $this->resource->toArray(),
            'participants' => [],
        ];
    }

    /**
     * Map comment record
     *
     * @param Comment $comment
     * @return array
     */
    protected function mapRecord(Comment $comment)
    {
        return [
            'id' => $comment->id,
            'content' => $comment->content,
            'time_posted' => $comment->getTimePostedAttribute(),
            'resolved_at' => $comment->resolved_at,
            'responses' => $comment->parent_id
                ? []
                : $comment->activeChildren->map(fn(Comment $response) => $this->mapRecord($response)),
            'author' => [
                'id' => $comment->author->id,
                'name' => $comment->author->name,
                'img' => $comment->author->profile_photo_url,
            ]
        ];
    }
}
