<?php

namespace Mtc\ContentManager\Tests;

use Illuminate\Database\Eloquent\Model;
use Kalnoy\Nestedset\NestedSetServiceProvider;
use Mtc\ContentManager\Providers\ContentProvider;
use Mtc\ContentManager\Providers\MediaProvider;
use Orchestra\Testbench\TestCase as Orchestra;

class TestCase extends Orchestra
{
    protected function getPackageProviders($app)
    {
        return [
            NestedSetServiceProvider::class,
            ContentProvider::class,
            MediaProvider::class,
        ];
    }

    protected function getEnvironmentSetUp($app): void
    {
        include_once __DIR__ . '/setup/migrations/2014_10_12_000000_testbench_create_users_table.php';

        (new \TestbenchCreateUsersTable)->up();
        $additional_filesystem_config = require(__DIR__ . '/setup/config/filesystems.php');
        $merged_config = array_merge($app['config']['filesystems.disks'], $additional_filesystem_config['disks']);
        $app['config']->set('filesystems.default_media', $additional_filesystem_config['default_media']);
        $app['config']->set('filesystems.disks', $merged_config);
        $app['config']->set('auth.providers.users.model', User::class);

    }

}
