<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\ImageSize;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\ContentManager\Models\MediaUse;

class CreateMediaSizeDimensions implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public $timeout = 0;

    public function __construct(protected readonly Collection $chunk, protected readonly MediaSize $mediaSize)
    {
        $this->onQueue('media');
    }

    public function handle()
    {
        $this->chunk->each(function (MediaUse $use) {
            try {
                Media::createSize(
                    $use->media,
                    new ImageSize($this->mediaSize->width, $this->mediaSize->height)
                );
            } catch (\Exception $exception) {
                Log::error('Failed to create image size', [
                    $exception->getMessage(),
                    $this->mediaSize->width,
                    $this->mediaSize->height,
                    $use,
                    $exception->getTrace(),
                ]);
            }
        });
    }
}
