<?php

namespace Mtc\ContentManager\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Support\Facades\DB;
use Mtc\ContentManager\Contracts\Menu;
use Mtc\ContentManager\Http\Requests\StoreMenuRequest;
use Mtc\ContentManager\Http\Requests\UpdateMenuRequest;
use Mtc\ContentManager\Http\Resources\MenuList;
use Mtc\ContentManager\Http\Resources\MenuView;
use Mtc\ContentManager\Facades\Menu as MenuFacade;

class MenuController
{
    use ValidatesRequests;

    /**
     * List menus
     *
     * @param menu $menu
     * @return MenuList
     */
    public function index(Menu $menu): MenuList
    {
        return new MenuList($menu->newQuery()->paginate());
    }

    /**
     * Store a new menu
     *
     * @param StoreMenuRequest $request
     * @param Menu $menu
     * @return MenuView
     */
    public function store(StoreMenuRequest $request, Menu $menu): MenuView
    {
        $record = $menu->newQuery()->create($request->validated());
        return new MenuView($record->refresh());
    }

    /**
     * Display menu record
     *
     * @param Menu $menu
     * @return MenuView
     */
    public function show(Menu $menu): MenuView
    {
        return new MenuView($menu);
    }

    /**
     * Update the specified menu
     *
     * @param \Illuminate\Http\Request $request
     * @param Menu $menu
     * @return MenuView
     */
    public function update(UpdateMenuRequest $request, Menu $menu): MenuView
    {
        return new MenuView(MenuFacade::update($menu, $request));
    }

    /**
     * Remove the menu
     *
     * @param Menu $menu
     * @return bool
     */
    public function destroy(Menu $menu): bool
    {
        return $menu->delete();
    }
}
