<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class Select extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.select');
    }

    public function hasOptions(): bool
    {
        return true;
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'choices' => [
                'type' => 'textarea',
                'name' => __('content::fields.choices'),
                'instructions' => 'Enter each choice on a new line. <br/>For more control, '
                    . 'you may specify both a value and label like this:<br/>red : Red',
            ],
            'default_value' => [
                'type' => 'textarea',
                'name' => __('content::fields.default_value'),
                'instructions' => 'Appears when creating a new record',
            ],
            'allow_null' => [
                'type' => 'checkbox',
                'name' => 'Allow empty?',
            ],
            'multiple' => [
                'type' => 'checkbox',
                'name' => 'Allow multiple selections?',
            ],
            'return_format' => [
                'type' => 'select',
                'name' => 'Return Format',
                'instructions' => 'Specify the value returned',
                'values' => [
                    'value' => 'Value',
                    'label' => 'Label',
                    'both' => 'Both',
                ]
            ],
        ];
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
        ];
    }

    protected function convertListToOptions(string $choice_list)
    {
        return collect(explode("\n", $choice_list))
            ->each(function ($choice) {
                $data = explode(':', $choice);
                if (count($data) == 1) {
                    return [
                        'id' => $data[0],
                        'name' => $data[0],
                    ];
                }

                return [
                    'id' => $data[0],
                    'name' => $data[1],
                ];
            });
    }
}
