<?php

namespace Mtc\ContentManager\Traits;

use Illuminate\Database\Eloquent\Builder;

trait ModelSortAndFilter
{
    /**
     * Scope - setSortBy()
     *
     * @param Builder $query
     * @param string $sortOption
     * @return Builder
     */
    public function scopeSetSortBy(Builder $query, ?string $sortOption)
    {
        if (empty($sortOption)) {
            return $query;
        }
        $direction = str_ends_with($sortOption, '_desc') ? 'desc' : 'asc';
        return $query->orderBy(str_replace('_desc', '', $sortOption), $direction);
    }
}
