<?php

return [
    'media_model' => \Mtc\ContentManager\Models\Media::class,
    'tag_model' => \Mtc\ContentManager\Models\MediaTag::class,
    'media_use_model' => \Mtc\ContentManager\Models\MediaUse::class,
    'repository_class' => \Mtc\ContentManager\MediaRepository::class,


    'image_manager_config' => [
        'driver' => 'imagick',
    ],

    'supported_image_extensions' => [
        'jpg',
        'jpeg',
        'png',
        'gif',
        'svg'
    ],

    'library_page_size' => 24,

    'allow_lossy_optimization' => false,

    'lossless_image_optimize_binaries' => [
        'jpegoptim_bin' => '/usr/local/bin/jpegoptim',
        'optipng_bin' => '/usr/local/bin/optipng',
    ],

    'lossy_image_optimize_binaries' => [
        'jpegoptim_bin' => '/usr/local/bin/jpegoptim',
        'pngquant_bin' => '/usr/local/bin/pngquant',
        'optipng_bin' => '/usr/local/bin/optipng',
        'pngcrush_bin' => '/usr/local/bin/pngcrush',
        'pngquant_options' => ['--force', '--skip-if-larger', '--quality 75-85'],
        'jpegoptim_options' => ['--strip-all', '--all-progressive', '--max=80'],
    ],

    'image_optimise_exclude_binaries' => [
        'pngout_bin',
        'gifsicle_bin',
        'jpegoptim_bin',
    ],

    'default_thumbnail_size' => [
        'width' => 110,
        'height' => 110,
    ],

    'supported_image_mimes' => [
        'image/jpeg',
        'image/webp',
        'image/png',
    ],

    'media_use_pivot_columns' => [
        'alt_text',
        'data',
    ],

    'media_types' => [
        'image' => [
            'image/jpeg',
            'image/png',
            'image/webp',
        ],
        'audio' => [
            'audio/mpeg',
            'audio/ogg',
            'audio/vnd.wav',
        ],
        'video' => [
            'video/mp4',
            'video/x-ms-wmv',
            'video/x-msvideo',
            'video/mpeg',
            'video/quicktime',
            'video/3gpp',
        ],
        'documents' => [
            'application/pdf',
            'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document',
            'application/vnd.ms-excel', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
            'application/vnd.oasis.opendocument.text', 'application/vnd.oasis.opendocument.spreadsheet',
            'application/vnd.ms-powerpoint', 'application/vnd.openxmlformats-officedocument.presentationml.presentation',
            'application/vnd.ms-pps', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow',
            'image/vnd.adobe.photoshop',
        ],
        'archives' => [
            'application/zip',
            'application/gzip', 'application/x-gtar',
            'application/x-rar-compressed',
            'application/x-7z-compressed',
        ],
        'other' => [],
    ]
];
