<?php

namespace Mtc\ContentManager\Traits;

use Illuminate\Database\Eloquent\Relations\MorphMany;

trait HasMedia
{
    /**
     * Relationship with vehicle images/media
     *
     * @return MorphMany
     */
    public function mediaUses(): MorphMany
    {
        return $this->morphMany(config('media.media_use_model'), 'owner');
    }
}
