<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class Radio extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.radio');
    }

    public function hasOptions(): bool
    {
        return true;
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'choices' => [
                'type' => 'textarea',
                'name' => __('content::fields.choices'),
                'instructions' => 'Enter each choice on a new line. <br/>For more control,'
                    . ' you may specify both a value and label like this:<br/>red : Red',
            ],
            'allow_null' => [
                'type' => 'checkbox',
                'name' => 'Allow empty?',
            ],
            'allow_custom' => [
                'type' => 'checkbox',
                'name' => 'Allow additional values to be added?',
            ],
            'default_value' => [
                'type' => 'text',
                'name' => __('content::fields.default_value'),
                'instructions' => 'Appears when creating a new record',
            ],
            'layout' => [
                'type' => 'select',
                'name' => 'Layout',
                'default' => 'vertical',
                'values' => [
                    'vertical' => 'Vertical',
                    'horizontal' => 'Horizontal',
                ]
            ],
            'return_format' => [
                'type' => 'select',
                'name' => 'Return Format',
                'instructions' => 'Specify the value returned',
                'values' => [
                    'value' => 'Value',
                    'label' => 'Label',
                    'both' => 'Both',
                ]
            ],

        ];
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
        ];
    }
}
