<?php

namespace Mtc\ContentManager\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\ContentManager\Factories\MediaSizeFactory;
use Mtc\ContentManager\ImageSize;

class MediaSize extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'media_sizes';

    /**
     * @var string[]
     */
    protected $fillable = [
        'width',
        'height',
        'label'
    ];

    /**
     * Hidden from json/toArray
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * Added to json/toArray
     *
     * @var string[]
     */
    protected $appends = [
        'dimensions',
        'name',
        'size_url_path',
    ];

    /**
     * Model factory
     *
     * @return mixed
     */
    protected static function newFactory()
    {
        return MediaSizeFactory::new();
    }

    public function getDimensionsAttribute(): string
    {
        return $this->width . 'x' . $this->height;
    }

    public function getNameAttribute(): string
    {
        return $this->width . 'x' . $this->height . (!empty($this->label) ? " ($this->label)" : '');
    }

    public function getSizeUrlPathAttribute(): string
    {
        return (new ImageSize($this->width, $this->height))->fileUrl('');
    }
}
