<?php

namespace Mtc\ContentManager\Tests\Unit;

use Carbon\Carbon;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\Models\Version;
use Mtc\ContentManager\Tests\TestCase;

class DeleteOldPageVersionsTest extends TestCase
{
    use RefreshDatabase;

    public function testDoesNotRemoveRecentPageVersion()
    {
        $version = Version::factory()
            ->create([
                'is_active' => false,
                'updated_at' => Carbon::now()
            ]);


        $this->assertTrue(Version::query()->where('id', $version->id)->exists());
        $this->artisan('pages:delete-old-versions');
        $this->assertTrue(Version::query()->where('id', $version->id)->exists());
    }

    public function testDoesRemoveExpiredVersion()
    {
        $version = Version::factory()
            ->create([
                'is_active' => false,
                'updated_at' => Carbon::now()->subYear()
            ]);

        $this->artisan('pages:delete-old-versions');
        $this->assertFalse(Version::query()->where('id', $version->id)->exists());
    }

    public function testDoesNotRemoveOldButActivePageVersion()
    {
        $version = Version::factory()
            ->create([
                'is_active' => true,
                'updated_at' => Carbon::now()->subYear()
            ]);

        $this->artisan('pages:delete-old-versions');
        $this->assertTrue(Version::query()->where('id', $version->id)->exists());
    }
}
