<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreatePageTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('status', 25)->index();
            $table->dateTime('published_at')->nullable()->index();
            $table->string('slug')->index();
            $table->foreignId('template_id')->nullable();
            $table->mediumText('text')->nullable();
            $table->mediumText('seo')->nullable();
            $table->mediumText('meta')->nullable();
            $table->mediumText('data')->nullable();
            $table->text('search_content')->nullable();
            $table->timestamps();
            $table->softDeletes();

            if (app()->runningUnitTests() === false) {
                $table->fullText('search_content');
            }
        });

        Schema::create('page_users', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id')->index();
            $table->foreignId('user_id')->index();
        });

        Schema::create('page_versions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('author_id')->index()->nullable();
            $table->foreignId('page_id')->index();
            $table->boolean('is_active')->index();
            $table->mediumText('content')->nullable();
            $table->mediumText('structure')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('page_content', function (Blueprint $table) {
            $table->id();
            $table->foreignId('page_id')->index();
            $table->foreignId('parent_id')->nullable()->index();
            $table->foreignId('template_element_id')->nullable()->index();
            $table->foreignId('global_content_id')->nullable()->index();
            $table->foreignId('element_id')->nullable()->index();
            $table->string('name')->nullable();
            $table->mediumText('content')->nullable();
            $table->timestamps();
        });


        Schema::create('comments', function (Blueprint $table) {
            $table->id();
            $table->nullableMorphs('commentable');
            $table->foreignId('parent_id')->nullable()->index();
            $table->foreignId('author_id')->nullable()->index();
            $table->dateTime('resolved_at')->nullable()->index();
            $table->text('content')->nullable();
            $table->timestamps();
        });

        Schema::create('comment_tagged_users', function (Blueprint $table) {
            $table->id();
            $table->foreignId('comment_id')->nullable()->index();
            $table->foreignId('user_id')->nullable()->index();
            $table->timestamps();
        });


        Schema::create('global_content', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('slug')->nullable()->index();
            $table->mediumText('content')->nullable();
            $table->foreignId('element_id')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('global_content_users', function (Blueprint $table) {
            $table->id();
            $table->foreignId('content_id')->nullable()->index();
            $table->foreignId('user_id')->nullable()->index();
        });


        Schema::create('content_elements', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->nullable()->index();
            $table->string('subtitle')->nullable();
            $table->string('icon', 50)->nullable();
            $table->string('category')->nullable();
            $table->boolean('is_enabled')->default(1)->index();
            $table->timestamps();
        });

        Schema::create('content_element_fields', function (Blueprint $table) {
            $table->id();
            $table->foreignId('element_id')->index();
            $table->foreignId('child_element_id')->nullable()->index();
            $table->string('field_type')->index();
            $table->string('name');
            $table->text('data')->nullable();
            $table->text('choices')->nullable();
            $table->timestamps();
        });

        Schema::create('menus', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->nullable()->index();
            $table->text('description')->nullable();
            $table->foreignId('first_child_element_id')->nullable();
            $table->text('data')->nullable();
            $table->boolean('is_enabled')->default(1)->index();
            $table->timestamps();
        });

        Schema::create('menu_entries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('menu_id')->index();
            $table->foreignId('element_id')->index()->nullable();
            $table->nestedSet();
            $table->boolean('is_enabled')->default(0)->index();
            $table->string('name');
            $table->string('url')->nullable();
            $table->text('content')->nullable();
            $table->text('data')->nullable();
            $table->nullableMorphs('item');
            $table->timestamps();
        });

        Schema::create('page_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('slug')->nullable()->index();
            $table->text('description')->nullable();
            $table->text('seo_defaults')->nullable();
            $table->text('meta')->nullable();
            $table->string('status', 25)->default('draft')->index();
            $table->foreignId('updated_by')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('page_template_elements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('template_id')->index();
            $table->foreignId('element_id')->nullable()->index();
            $table->foreignId('global_content_id')->nullable()->index();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('hint')->nullable();
            $table->boolean('is_list')->default(0);
            $table->smallInteger('max_repeat_count')->default(0);
            $table->smallInteger('order')->default(0)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pages');
        Schema::dropIfExists('page_users');
        Schema::dropIfExists('page_versions');
        Schema::dropIfExists('page_content');
        Schema::dropIfExists('global_content');
        Schema::dropIfExists('page_templates');
        Schema::dropIfExists('page_template_elements');
        Schema::dropIfExists('content_elements');
        Schema::dropIfExists('content_element_fields');
        Schema::dropIfExists('menus');
        Schema::dropIfExists('menu_entries');
    }
}
