<?php

namespace Mtc\ContentManager\Observers;

use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Contracts\Template;

class TemplateObserver
{
    public function saving(Template $layout)
    {
        if ($layout->isDirty()) {
            $this->attachUpdatedBy($layout);
        }
    }

    private function attachUpdatedBy(Template $layout)
    {
        $layout->updated_by = Auth::id();
    }
}
