<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class Checkbox extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.checkbox');
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'choices' => [
                'type' => 'textarea',
                'name' => __('content::fields.choices'),
                'instructions' => __('content::fields.instruction_text.choices'),
            ],
            'allow_custom' => [
                'type' => 'checkbox',
                'name' => __('content::fields.instruction_text.choices'),
            ],
            'default_value' => [
                'type' => 'textarea',
                'name' => __('content::fields.default_value'),
                'instructions' => __('content::fields.instruction_text.choices'),
            ],
            'layout' => [
                'type' => 'select',
                'name' => __('content::fields.layout'),
                'values' => [
                    'vertical' => 'Vertical',
                    'horizontal' => 'Horizontal',
                ]
            ],
            'toggle_all' => [
                'type' => 'checkbox',
                'name' => __('content::fields.toggle_all'),
                'instructions' => __('content::fields.instruction_text.toggle_all'),
            ],
        ];
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
        ];
    }

    /**
     * Whether field has options/choices
     *
     * @return bool
     */
    public function hasOptions(): bool
    {
        return true;
    }
}
