<?php

namespace Mtc\ContentManager\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Contracts\VersionModel;

class DeleteOldPageVersions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'pages:delete-old-versions';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Deletes old versions of pages';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(protected VersionModel $version)
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle(): int
    {
        $delay = Config::get('pages.page_versions_deleted_after_days');
        $this->version->newQuery()
            ->where('is_active', 0)
            ->where('updated_at', '<=', Carbon::now()->subDays($delay))
            ->delete();
        return 0;
    }
}
