<?php

namespace Mtc\ContentManager\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Kalnoy\Nestedset\NodeTrait;
use Mtc\ContentManager\Factories\MenuEntryFactory;

abstract class MenuEntry extends Model
{
    use NodeTrait;
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'menu_entries';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'menu_id',
        'element_id',
        'parent_id',
        'name',
        'url',
        'content',
        'data',
        'is_enabled',
        'item_id',
        'item_type',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'content' => 'array',
        'data' => 'array',
        'is_enabled' => 'boolean',
    ];

    /**
     * Model Factory
     *
     * @return MenuEntryFactory
     */
    protected static function newFactory()
    {
        return MenuEntryFactory::new();
    }

    /**
     * Relationship with menu
     *
     * @return BelongsTo
     */
    public function menu(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.menu_model'), 'menu_id');
    }

    /**
     * Item that defines the entry
     *
     * @return \Illuminate\Database\Eloquent\Relations\MorphTo
     */
    public function item()
    {
        return $this->morphTo();
    }
}
