<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;

class MediaUpdateRequest extends MediaUploadRequest
{

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $fileRules = $this->files->has('file') ? $this->fileRules() : 'sometimes';
        return [
            'alt_text' => 'required',
            'title' => 'present',
            'caption' => 'present',
            'description' => 'present',
            'file' => $fileRules,
        ];
    }
}
