<?php

namespace Mtc\ContentManager;

use Illuminate\Support\Collection;

class TemplateRepository
{
    public const LAYOUT_TYPES = [
        'list',
        'columns',
    ];

    public function contentToLayout(array $contentStructure): array
    {
        return collect($contentStructure)
            ->map(function ($block) {
                if (isset($block['type']) && in_array($block['type'], self::LAYOUT_TYPES)) {
                    $block['items'] = $this->contentToLayout($block['items']);
                } else {
                    $block['fields'] =  collect($block['fields'])->forget('value');
                }
                return $block;
            })
            ->toArray();
    }

    public function extractBlockIds(array $request_structure): array
    {
        return $this->recursiveExtractBlockIds($request_structure)
            ->flatten()
            ->unique()
            ->toArray();
    }

    protected function recursiveExtractBlockIds(array $requestStructure): Collection
    {
        return collect($requestStructure)
            ->map(function ($block) {
                if (isset($block['type']) && in_array($block['type'], self::LAYOUT_TYPES)) {
                    return $this->recursiveExtractBlockIds($block['items']);
                }
                return $block['block_id'];
            });
    }
}
