<?php

namespace Mtc\ContentManager\Casts;

use Illuminate\Contracts\Database\Eloquent\CastsAttributes;

class SeoDataCast implements CastsAttributes
{
    /**
     * Cast the given value.
     *
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array  $attributes
     * @return mixed
     */
    public function get($model, string $key, $value, array $attributes)
    {
        $data = json_decode($value, true);

        return [
            'title' => $data['title'] ?? '',
            'description' => $data['description'] ?? '',
            'keywords' => $data['keywords'] ?? '',
            'canonical' => $data['canonical'] ?? '',
            'index_follow' => $data['index_follow'] ?? null,
            'heading' => $data['heading'] ?? '',
        ];
    }

    /**
     * Prepare the given value for storage.
     *
     * @param  \Illuminate\Database\Eloquent\Model  $model
     * @param  string  $key
     * @param  mixed  $value
     * @param  array  $attributes
     * @return mixed
     */
    public function set($model, string $key, $value, array $attributes)
    {
        return json_encode([
            'title' => $value['title'] ?? '',
            'description' => $value['description'] ?? '',
            'keywords' => $value['keywords'] ?? '',
            'canonical' => $value['canonical'] ?? '',
            'index_follow' => $value['index_follow'] ?? null,
            'heading' => $value['heading'] ?? '',
        ]);
    }
}
