<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class TextArea extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.textarea');
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'default_value' => [
                'type' => 'textarea',
                'name' => __('content::fields.default_value'),
                'instructions' => 'Appears when creating a new record',
            ],
            'character_limit' => [
                'type' => 'text',
                'name' => __('content::fields.character_limit'),
                'instructions' => 'Leave blank for no limit',
            ],
            'rows' => [
                'type' => 'text',
                'name' => 'Rows',
                'instructions' => 'Sets the textarea height'
            ],
            'new_lines' => [
                'type' => 'select',
                'name' => 'New Lines',
                'instructions' => 'Controls how new lines are rendered',
                'values' => [
                    'no_formatting' => 'No Formatting',
                    'paragraph' => 'Automatically add Paragraphs',
                    'br' => 'Automatically add <br/>'
                ]
            ],

        ];
    }

    public function getValue($value)
    {
        return $value->text_value;
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
            ($field->data['character_limit'] ?? 0) > 0 ? 'max:' . $field->data['character_limit'] : '',
        ];
    }
}
