<?php

namespace Mtc\ContentManager\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;
use Mtc\ContentManager\Models\Page;
use Mtc\ContentManager\PageStatus;

class PageFactory extends Factory
{
    protected $model = Page::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'title' => $this->faker->name,
            'status' => PageStatus::DRAFT,
            'slug' => Str::slug($this->faker->title),
            'template_id' => random_int(0, 1) ? random_int(0, 50) : null,
            'text' => null,
            'seo' => null,
            'meta' => null,
            'data' => null,
        ];
    }
}
