<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SaveImageSizesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'sizes' => [
                'required',
                'array',
            ],
            'sizes.*.width' => [
                'required',
                'numeric',
                'min:0',
            ],
            'sizes.*.height' => [
                'required',
                'numeric',
                'min:0',
            ],
            'sizes.*.label' => [
                'sometimes',
            ],
        ];
    }

    protected function prepareForValidation()
    {
        $this->merge([
            'sizes' => collect(explode("\n", $this->input('sizes', '')))
                ->map(function ($size) {
                    $size_and_label = explode(':', $size);
                    $dimensions = explode('x', $size_and_label[0]);
                    return [
                        'width' => $dimensions[0],
                        'height' => $dimensions[1] ?? null,
                        'label' => $size_and_label[1] ?? null,
                    ];
                })->toArray()
        ]);
    }
}
