<?php

namespace Mtc\ContentManager\Observers;

use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Contracts\PageModel;
use Mtc\ContentManager\Contracts\Template;
use Mtc\ContentManager\Contracts\TemplateElement;

class PageObserver
{
    /**
     * Things to do when Page was created
     *
     * @param PageModel $page
     */
    public function created(PageModel $page)
    {
        $this->attachUser($page, Auth::id());
    }

    /**
     * Attach user to page
     *
     * @param PageModel $page
     * @param $user_id
     */
    protected function attachUser(PageModel $page, $user_id)
    {
        $page->users()->attach($user_id);
    }
}
