<?php

namespace Mtc\ContentManager\Contracts;

use Illuminate\Database\Eloquent\Relations\MorphTo;

abstract class VersionContentModel extends Content
{
    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'version_content';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'template_element_id',
        'global_content_id',
        'element_id',
        'slug',
        'owner_id',
        'owner_type',
        'parent_id',
        'name',
        'content',
        'data',
        'order',
    ];

    /**
     * Relationship to the owner page of this version
     *
     * @return MorphTo
     */
    public function owner(): MorphTo
    {
        return $this->morphTo('owner');
    }
}
