<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Mtc\ContentManager\Rules\GlobalContentHasAllBlueprintFields;

class UpdateGlobalContentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'element_id' => [
                'required',
                'numeric',
                'exists:content_elements,id',
            ],
            'content' => [
                'required',
                'array',
                new GlobalContentHasAllBlueprintFields($this->input('element_id')),
            ],
        ];
    }

    /**
     * Attribute names
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'element_id' => __('content::validation_attributes.element_id')
        ];
    }
}
