<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class GlobalContentElementView extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource->load('mediaUses.media');
        $this->resource->content = $this->resource->contentElement?->fields
            ->map(fn($field) => $this->mapField($field));

        $this->resource->setVisible([
            'id',
            'fields',
            'slug',
            'name',
            'ui_component',
            'element_id',
            'content',
            'type',
        ]);
        return parent::toArray($request);
    }

    protected function mapField($field)
    {
        $field->content = $this->getValueFormContent($field);
        $field->icon = $this->getIcon($field->field_type);
        $field->component = $this->getComponent($field->field_type);
        return $field;
    }

    protected function getIcon(string $type): string
    {
        return match ($type) {
            'text' => 'text',
            'email' => 'at',
            'number' => 'hashtag',
            'date' => 'calendar-days',
            'textarea' => 'font-case',
            'file' => 'file',
            'image' => 'image',
            'location' => 'location-dot',
            'select' => 'list-dropdown',
            'boolean' => 'square-check',
            'checkbox' => 'square',
            'offer_id' => 'badge-dollar',
            'page_id' => 'file-lines',
            'vehicle_id' => 'car',
            default => 'text',
        };
    }

    protected function getComponent(string $type): string
    {
        return match ($type) {
            'text' => 'EditableContentTextField',
            'image' => 'EditableContentImageUpload',
            'editor' => 'EditableContentEditor',
            default => '',
        };
    }

    protected function getValueFormContent($field)
    {
        $value = collect($this->resource->content)
            ->filter(fn($value) => ($value['id'] ?? '') === $field->id)
            ->first();

        if ($value && $field->field_type === 'image') {
            return collect($value['content'])->pluck('id')->toArray();
        }

        return $value['content'] ?? null;
    }
}
