<?php

namespace Mtc\ContentManager\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Log;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\ImageSize;
use Mtc\ContentManager\Models\MediaSize;
use Mtc\ContentManager\Models\MediaUse;

class ChangeMediaSizeDimensions implements ShouldQueue
{
    use Dispatchable;
    use InteractsWithQueue;
    use Queueable;
    use SerializesModels;

    public function __construct(protected readonly MediaSize $mediaSize, protected readonly array $original)
    {
        //
    }

    public function handle()
    {
        Log::debug('media size values', [
            $this->mediaSize->width,
            $this->mediaSize->height,
            $this->original,
        ]);
        MediaUse::query()
            ->with('media')
            ->where('owner_type', $this->mediaSize->model)
            ->chunk(100, fn(Collection $chunk) => $chunk->each(fn(MediaUse $use) => Media::changeMediaSize(
                $use,
                ImageSize::fromArray($this->original),
                ImageSize::fromArray($this->mediaSize->getAttributes())
            )));
    }
}
