<?php

namespace Mtc\ContentManager\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Log;
use Mtc\ContentManager\Contracts\ContentElement;
use Mtc\ContentManager\Contracts\ContentElementField;

class GlobalContentHasAllBlueprintFields implements Rule
{
    private ContentElement $element;

    private $blueprint;

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(protected ?int $elementId)
    {
        $this->element = App::make(ContentElement::class);
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!is_array($value)) {
            return false;
        }

        $value = collect($value)
            ->keyBy(fn ($entry) => $entry['name'])
            ->toArray();

        /** @var ContentElement|null $blueprint */
        $this->blueprint = $this->element->newQuery()->where('is_enabled', true)->find($this->elementId);
        if ($this->blueprint === null) {
            return false;
        }

        // Check if fields are missing
        return $this->blueprint->fields()->get()
            ->reject(fn (ContentElementField $field) => array_key_exists($field->name, $value))
            ->isEmpty();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        if ($this->blueprint === null) {
            return 'The content element was not found.';
        }

        return 'The content of "' . $this->blueprint->title . '" element does not have all blueprint fields.';
    }
}
