<?php

namespace Mtc\ContentManager\Http\Controllers;

use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Mtc\ContentManager\Contracts\Media as MediaModel;
use Mtc\ContentManager\Facades\Media;
use Mtc\ContentManager\Http\Requests\BulkDeleteMediaRequest;
use Mtc\ContentManager\Http\Resources\MediaFileUsageResource;

class MediaLibraryController
{
    use ValidatesRequests;

    /**
     * Show media library home.
     * This shows all details like types, dates and available tags
     *
     * @param Request $request
     * @return array
     */
    public function index(Request $request)
    {
        return [
            'files' => Media::getFiles($request),
            'types' => Media::getTypes(),
            'upload_dates' => Media::getUploadDates(),
            'tags' => Media::getTags(),
        ];
    }

    /**
     * Show media files. Allows filtering by request.
     *
     * @param Request $request
     * @return array
     */
    public function show(Request $request)
    {
        return Media::getFiles($request);
    }

    /**
     * Show use cases of media file
     *
     * @param MediaModel $media
     * @return MediaFileUsageResource
     */
    public function showUses(MediaModel $media)
    {
        return new MediaFileUsageResource($media->uses);
    }

    /**
     * Remove the media object
     *
     * @param int $mediaId
     * @return Response
     */
    public function bulkDelete(BulkDeleteMediaRequest $request): Response
    {
        Media::destroyMedia($request->input('id'));
        return response('success', 200);
    }
}
