<?php

namespace Mtc\ContentManager\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Mtc\ContentManager\PageStatus;
use Mtc\ContentManager\Rules\IsSlugRule;
use Mtc\ContentManager\Rules\PageContentHasAllBlueprintFields;

class UpdatePageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required',
            'slug' => [
                'present',
                new IsSlugRule(),
                'unique:pages,slug,' . ($this->page->id ?? 0)
            ],
            'published_at' => 'sometimes',
            'status' => [
                'required',
                Rule::in(array_map(static fn (PageStatus $status) => $status->value, PageStatus::cases())),
            ],
            'seo' => 'array',
            'meta' => 'array',
            'content' => [
                'array',
            ],
            'content.*.id' => [
                'nullable',
                'numeric',
            ],
            'content.*.element_id' => [
                'nullable',
                'numeric',
                'exists:content_elements,id'
            ],
            'content.*.global_content_id' => [
                'nullable',
                'numeric',
                'exists:global_content,id'
            ],
            'content.*.content' => [
                'nullable',
            ],
            'content.*' => [
                'array',
                new PageContentHasAllBlueprintFields(),
            ],
        ];
    }
}
