<?php

namespace Mtc\ContentManager\Contracts;

use Illuminate\Contracts\Support\Arrayable;

abstract class FormField implements Arrayable
{
    public function __construct(protected array $config = [])
    {
        //
    }

    /**
     * Name of the field
     *
     * @return string
     */
    abstract public function name(): string;

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    abstract public function fields(): array;

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    abstract public function validationRules(ContentElementField $field, bool $is_filled = true): array;

    /**
     * Check if field requires to be input
     *
     * @return bool
     */
    public function requiresInput(): bool
    {
        return true;
    }

    /**
     * Retrieve value of the field
     *
     * @param $value
     * @return mixed
     */
    public function getValue($value)
    {
        return $value->value;
    }

    /**
     * Whether field has options/choices
     *
     * @return bool
     */
    public function hasOptions(): bool
    {
        return false;
    }

    /**
     * Implementation of array conversion
     *
     * @return array
     */
    public function toArray()
    {
        return [
            'name' => $this->name(),
            'has_options' => $this->hasOptions(),
            'requires_input' => $this->requiresInput(),
            'fields' => $this->fields(),
        ];
    }
}
