<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class Message extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.message');
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'message' => [
                'type' => 'textarea',
                'name' => 'Message',
            ],
            'style' => [
                'type' => 'select',
                'name' => 'Style / Type',
                'value' => 'information',
                'values' => [
                    'description' => 'Generic message, no formatting',
                    'information' => 'Information alert',
                    'warning' => 'Warning alert',
                    'error' => 'Error alert',
                ]
            ],
            'new_lines' => [
                'type' => 'select',
                'name' => 'New Lines',
                'value' => 'no_formatting',
                'instructions' => 'Controls how new lines are rendered',
                'values' => [
                    'no_formatting' => 'No Formatting',
                    'paragraph' => 'Automatically add Paragraphs',
                    'br' => 'Automatically add line breaks (<br/>)'
                ]
            ],
        ];
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [];
    }
}
