<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class Url extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.url');
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'default_value' => [
                'type' => 'text',
                'name' => __('content::fields.default_value'),
                'instructions' => 'Appears when creating a new record',
            ],
            'placeholder' => [
                'type' => 'text',
                'name' => __('content::fields.placeholder'),
                'instructions' => 'Appears within the input',
            ],
        ];
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        if ($is_filled == false && empty($field->data['required'])) {
            return [];
        }

        return [
            !empty($field->data['required']) ? 'required' : 'sometimes',
            'url',
        ];
    }
}
