<?php

return [
    'media_model' => \Mtc\ContentManager\Models\Media::class,
    'tag_model' => \Mtc\ContentManager\Models\MediaTag::class,
    'media_use_model' => \Mtc\ContentManager\Models\MediaUse::class,
    'repository_class' => \Mtc\ContentManager\MediaRepository::class,


    'image_manager_config' => [
        'driver' => 'imagick',
    ],

    'supported_image_extensions' => [
        'jpg',
        'jpeg',
        'png',
        'gif',
        'svg'
    ],

    'library_page_size' => 24,

    'allow_lossy_optimization' => false,

    'lossless_image_optimize_binaries' => [
        'jpegoptim_bin' => '/usr/local/bin/jpegoptim',
        'optipng_bin' => '/usr/local/bin/optipng',
    ],

    'lossy_image_optimize_binaries' => [
        'jpegoptim_bin' => '/usr/local/bin/jpegoptim',
        'pngquant_bin' => '/usr/local/bin/pngquant',
        'optipng_bin' => '/usr/local/bin/optipng',
        'pngcrush_bin' => '/usr/local/bin/pngcrush',
        'pngquant_options' => ['--force', '--skip-if-larger', '--quality 75-85'],
        'jpegoptim_options' => ['--strip-all', '--all-progressive', '--max=80'],
    ],

    'image_optimise_exclude_binaries' => [
        'pngout_bin',
        'gifsicle_bin',
        'jpegoptim_bin',
    ],

    'default_thumbnail_size' => [
        'width' => 110,
        'height' => 110,
    ],

    'supported_image_mimes' => [
        'image/jpeg',
        'image/webp',
        'image/png',
    ],

    'media_use_pivot_columns' => [
        'alt_text',
        'data',
    ],

    'media_types' => [
        'image' => [
            'jpg',
            'jpeg',
            'png',
            'webp',
        ],
        'audio' => [
            'mp3',
            'm4a',
            'ogg',
            'wav',
        ],
        'video' => [
            'mp4', 'm4v',
            'mov',
            'wmv',
            'avi',
            'mpg',
            'ogv',
            '3gp',
            '3g2',
        ],
        'documents' => [
            'pdf',
            'doc', 'docx', 'odt',
            'xls', 'xlsx', 'ods',
            'ppt', 'pptx', 'pps', 'ppsx',
            'psd',
        ],
        'archives' => [
            'zip',
            'gz', 'tar',
            'rar',
            '7z',
        ],
        'other' => [],
    ]
];
