<?php

namespace Mtc\ContentManager\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Factories\PageVersionFactory;

abstract class VersionModel extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'page_versions';

    /**
     * @var string[]
     */
    protected $fillable = [
        'page_id',
        'author_id',
        'is_active',
        'content',
        'structure',
    ];

    /**
     * @var string[]
     */
    protected $casts = [
        'content' => 'array',
        'is_active' => 'bool',
    ];

    /**
     * Model factory
     *
     * @return PageVersionFactory
     */
    protected static function newFactory()
    {
        return PageVersionFactory::new();
    }

    /**
     * Relationship to the owner page of this version
     *
     * @return BelongsTo
     */
    public function page(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.page_model'));
    }

    /**
     * Author of this page version
     *
     * @return BelongsTo
     */
    public function author(): BelongsTo
    {
        return $this->belongsTo(Config::get('auth.providers.users.model'));
    }
}
