<?php

namespace Mtc\ContentManager\Providers;

use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Contracts\Media;
use Mtc\ContentManager\Contracts\MediaUse;
use Mtc\ContentManager\Contracts\MediaTag;
use Mtc\ContentManager\Events\GlobalContentChanged;
use Mtc\ContentManager\Listeners\RefreshPageTextOnGlobalContentChange;

class MediaProvider extends EventServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
        GlobalContentChanged::class => [
            RefreshPageTextOnGlobalContentChange::class,
        ],
    ];

    /**
     * Register service
     *
     * @return void
     */
    public function register(): void
    {
        $this->mergeConfigFrom(dirname(__DIR__, 2) . '/config/media.php', 'media');
        parent::register();

        $this->app->bind(Media::class, Config::get('media.media_model'));
        $this->app->bind(MediaTag::class, Config::get('media.tag_model'));
        $this->app->bind(MediaUse::class, Config::get('media.media_use_model'));
        $this->app->bind('media_repository', Config::get('media.repository_class'));
    }

    /**
     * Boot the service provider.
     *
     * @return void
     */
    public function boot(): void
    {
        Relation::morphMap([
            'media' => Config::get('media.media_model'),
            'media_use' => Config::get('media.media_use_model')
        ]);
    }
}
