<?php

namespace Mtc\ContentManager\Rules;

use Illuminate\Contracts\Validation\Rule;
use Illuminate\Support\Facades\App;
use Mtc\ContentManager\Contracts\ContentElement;
use Mtc\ContentManager\Contracts\ContentElementField;

class GlobalContentHasAllBlueprintFields implements Rule
{
    private ContentElement $element;
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(protected int $elementId)
    {
        $this->element = App::make(ContentElement::class);
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function passes($attribute, $value)
    {
        if (!is_array($value)) {
            return false;
        }

        /** @var ContentElement|null $blueprint */
        $blueprint = $this->element->newQuery()->where('is_enabled', true)->find($this->elementId);
        if ($blueprint === null) {
            return false;
        }

        // Check if fields are missing
        return $blueprint->fields()->get()
            ->reject(fn (ContentElementField $field) => array_key_exists($field->name, $value))
            ->isEmpty();
    }

    /**
     * Get the validation error message.
     *
     * @return string
     */
    public function message()
    {
        return 'The content of element does not have all blueprint fields.';
    }
}
