<?php

namespace Mtc\ContentManager\Fields;

use Mtc\ContentManager\Contracts\ContentElementField;
use Mtc\ContentManager\Contracts\FormField;

class File extends FormField
{
    /**
     * Name of the field
     *
     * @return string
     */
    public function name(): string
    {
        return __('content::fields.names.file');
    }

    /**
     * List of the configuration fields for this input field
     *
     * @return array
     */
    public function fields(): array
    {
        return [
            'instructions' => [
                'type' => 'textarea',
                'name' => __('content::fields.instructions'),
                'instructions' => __('content::fields.instruction_text.instructions'),
            ],
            'required' => [
                'type' => 'checkbox',
                'name' => __('content::fields.required'),
            ],
            'return_format' => [
                'type' => 'select',
                'name' => 'Return Format',
                'values' => [
                    'array' => 'File Array',
                    'url' => 'File URL',
                    'id' => 'File ID'
                ],
            ],
            'library' => [
                'type' => 'select',
                'name' => 'Library',
                'instructions' => 'Limit the media Library choice',
                'values' => [
                    'all' => 'All',
                    'owner-type' => 'Uploaded to this object type',
                ],
            ],
            'min_value' => [
                'type' => 'text',
                'name' => 'Minimum File Size (MB)',
                'instructions' => 'Restrict which files can be uploaded',
            ],
            'max_value' => [
                'type' => 'text',
                'name' => 'Maximum File Size (MB)',
                'instructions' => 'Restrict which files can be uploaded',
            ],
            'allowed_file_types' => [
                'type' => 'text',
                'name' => 'Allowed File Types',
                'instructions' => 'Comma separated list. Leave blank for all types',
            ],

        ];
    }

    /**
     * Validation rules set on field
     *
     * @param ContentElementField $field
     * @param bool $is_filled
     * @return array
     */
    public function validationRules(ContentElementField $field, bool $is_filled = true): array
    {
        return [
            !empty($field->data['required']) ? 'required' : '',
        ];
    }
}
