<?php

namespace Mtc\ContentManager\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\Support\Facades\Log;

class TemplateListResource extends JsonResource
{
    /**
     * @var LengthAwarePaginator
     */
    public $resource;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->resource = $this->resource
            ->through(fn($template) => [
                'id' => $template->id,
                'name' => $template->name,
                'updated_at' => $template->updated_at->diffForHumans(),
                'comment_count' => $template->comment_count,
                'usage_count' => $template->usage_count,
                'updated_by' => [
                    'id' => $template->updatedBy->id,
                    'name' => $template->updatedBy->name,
                    'profile_photo_url' => $template->updatedBy->profile_photo_url,
                ]
            ]);

        return parent::toArray($request);
    }
}
